# Pharmacy Inventory Management System

A web-based pharmacy inventory management system built with PHP and MySQL.

## Features
- User Registration and Login System
- Inventory Management
- Stock Tracking
- Basic Reporting

## Requirements
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web Server (Apache/Nginx)

## Setup Instructions
1. Clone this repository
2. Create a MySQL database named 'pharmacy_db'
3. Import the database schema from `database/schema.sql`
4. Configure database connection in `config/database.php`
5. Set up your web server to point to the project directory
6. Access the application through your web browser

## Directory Structure
```
├── config/
│   └── database.php
├── includes/
│   ├── header.php
│   └── footer.php
├── assets/
│   ├── css/
│   └── js/
├── database/
│   └── schema.sql
└── pages/
    ├── login.php
    ├── register.php
    ├── dashboard.php
    └── inventory/
        ├── add.php
        ├── edit.php
        ├── delete.php
        └── list.php
``` 