<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once dirname(__DIR__) . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) && basename($_SERVER['PHP_SELF']) !== 'login.php' && basename($_SERVER['PHP_SELF']) !== 'register.php') {
    header('Location: ' . getUrlPath('pages/login.php'));
    exit();
}

// Get user's first name
$first_name = '';
if (isset($_SESSION['full_name'])) {
    $name_parts = explode(' ', $_SESSION['full_name']);
    $first_name = $name_parts[0];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PharmacyPro - Inventory Management System</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <style>
        .sidebar {
            min-height: 100vh;
            background: #4e73df;
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,.8);
        }
        .sidebar .nav-link:hover {
            color: #fff;
        }
        .sidebar .nav-link.active {
            color: #fff;
            background: rgba(255,255,255,.1);
        }
        .main-content {
            padding: 20px;
        }
        .navbar-brand {
            font-weight: bold;
        }
        .card {
            border: none;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        }
        .card-header {
            background-color: #f8f9fc;
            border-bottom: 1px solid #e3e6f0;
        }
        .border-left-primary {
            border-left: 4px solid #4e73df !important;
        }
        .border-left-success {
            border-left: 4px solid #1cc88a !important;
        }
        .border-left-warning {
            border-left: 4px solid #f6c23e !important;
        }
        .border-left-danger {
            border-left: 4px solid #e74a3b !important;
        }
        .text-gray-300 {
            color: #dddfeb !important;
        }
        .text-gray-800 {
            color: #5a5c69 !important;
        }
        .text-xs {
            font-size: .7rem;
        }
        .welcome-text {
            color: #fff;
            margin-right: 15px;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            padding: 0.5rem 0;
        }
        .welcome-text i {
            margin-right: 5px;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo getUrlPath('pages/dashboard.php'); ?>">
                <i class="fas fa-clinic-medical"></i> PharmacyPro
            </a>
            <?php if (isset($_SESSION['user_id'])): ?>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo getUrlPath('pages/dashboard.php'); ?>">
                            <i class="fas fa-tachometer-alt"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo getUrlPath('pages/inventory/list.php'); ?>">
                            <i class="fas fa-box"></i> Inventory
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo getUrlPath('pages/receiving/add.php'); ?>">
                            <i class="fas fa-truck"></i> Receiving
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo getUrlPath('pages/dispensing/add.php'); ?>">
                            <i class="fas fa-prescription"></i> Dispensing
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo getUrlPath('pages/suppliers/list.php'); ?>">
                            <i class="fas fa-truck-loading"></i> Suppliers
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo getUrlPath('pages/reports/index.php'); ?>">
                            <i class="fas fa-chart-bar"></i> Reports
                        </a>
                    </li>
                </ul>
                <ul class="navbar-nav">
                    <?php if (isset($_SESSION['full_name'])): ?>
                    <li class="nav-item">
                        <span class="welcome-text">
                            <i class="fas fa-user"></i> Welcome, <?php echo htmlspecialchars(explode(' ', $_SESSION['full_name'])[0]); ?>
                        </span>
                    </li>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo getUrlPath('pages/logout.php'); ?>">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </li>
                </ul>
            </div>
            <?php endif; ?>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container-fluid">
        <div class="row">
            <?php if (isset($_SESSION['user_id'])): ?>
            <!-- Sidebar -->
            <div class="col-md-2 sidebar py-3">
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'dashboard.php' ? 'active' : ''; ?>" 
                           href="<?php echo getUrlPath('pages/dashboard.php'); ?>">
                            <i class="fas fa-tachometer-alt"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'list.php' ? 'active' : ''; ?>" 
                           href="<?php echo getUrlPath('pages/inventory/list.php'); ?>">
                            <i class="fas fa-box"></i> View Inventory
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'add.php' && strpos($_SERVER['PHP_SELF'], 'receiving') !== false ? 'active' : ''; ?>" 
                           href="<?php echo getUrlPath('pages/receiving/add.php'); ?>">
                            <i class="fas fa-truck"></i> Receiving
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'add.php' && strpos($_SERVER['PHP_SELF'], 'dispensing') !== false ? 'active' : ''; ?>" 
                           href="<?php echo getUrlPath('pages/dispensing/add.php'); ?>">
                            <i class="fas fa-prescription"></i> Dispensing
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo strpos($_SERVER['PHP_SELF'], 'suppliers') !== false ? 'active' : ''; ?>" 
                           href="<?php echo getUrlPath('pages/suppliers/list.php'); ?>">
                            <i class="fas fa-truck-loading"></i> Suppliers
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) === 'index.php' && strpos($_SERVER['PHP_SELF'], 'reports') !== false ? 'active' : ''; ?>" 
                           href="<?php echo getUrlPath('pages/reports/index.php'); ?>">
                            <i class="fas fa-chart-bar"></i> Reports
                        </a>
                    </li>
                </ul>
            </div>
            <div class="col-md-10 main-content">
                <?php if (isset($_SESSION['info_message'])): ?>
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <?php 
                        echo $_SESSION['info_message'];
                        unset($_SESSION['info_message']);
                        ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
            <?php endif; ?> 