<?php
session_start();
require_once dirname(__DIR__) . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: ' . getUrlPath('pages/login.php'));
    exit();
}

// Get database connection
$pdo = getDBConnection();

// Get inventory statistics
$total_items = getRow("SELECT COUNT(*) as count FROM inventory")['count'];
$low_stock = getRow("SELECT COUNT(*) as count FROM inventory WHERE quantity <= reorder_point")['count'];
$expiring_soon = getRow("SELECT COUNT(*) as count FROM inventory WHERE expiry_date <= DATE_ADD(CURDATE(), INTERVAL 30 DAY)")['count'];
$total_value = getRow("SELECT SUM(quantity * unit_price) as total FROM inventory")['total'];

// Get recent transactions
$recent_transactions = getRows("
    SELECT 
        'receiving' as type,
        r.receipt_date as date,
        s.name as supplier,
        ri.quantity,
        p.product_name,
        u.username as user
    FROM receiving_records r
    JOIN suppliers s ON r.supplier_id = s.id
    JOIN receiving_items ri ON r.id = ri.receiving_record_id
    JOIN inventory p ON ri.product_id = p.id
    JOIN users u ON r.created_by = u.id
    ORDER BY r.receipt_date DESC
    LIMIT 5
");

require_once getIncludePath('includes/header.php');
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h1 class="h3 mb-4 text-gray-800">Dashboard</h1>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Inventory Value</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">₦<?php echo number_format($total_value, 2); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Total Products</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $total_items; ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-box fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Low Stock Items</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $low_stock; ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Expiring Soon</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $expiring_soon; ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row">
        <div class="col-12 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Quick Actions</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-2 mb-3">
                            <a href="<?php echo getUrlPath('pages/inventory/add.php'); ?>" class="btn btn-primary btn-block">
                                <i class="fas fa-plus"></i> Add New Product
                            </a>
                        </div>
                        <div class="col-md-2 mb-3">
                            <a href="<?php echo getUrlPath('pages/receiving/add.php'); ?>" class="btn btn-success btn-block">
                                <i class="fas fa-truck"></i> Record Receipt
                            </a>
                        </div>
                        <div class="col-md-2 mb-3">
                            <a href="<?php echo getUrlPath('pages/dispensing/add.php'); ?>" class="btn btn-info btn-block">
                                <i class="fas fa-prescription"></i> Record Dispensing
                            </a>
                        </div>
                        <div class="col-md-2 mb-3">
                            <a href="<?php echo getUrlPath('pages/inventory/list.php'); ?>" class="btn btn-secondary btn-block">
                                <i class="fas fa-list"></i> View Inventory
                            </a>
                        </div>
                        <div class="col-md-2 mb-3">
                            <a href="<?php echo getUrlPath('pages/reports/index.php'); ?>" class="btn btn-warning btn-block">
                                <i class="fas fa-chart-bar"></i> Reports
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Transactions -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Recent Transactions</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Type</th>
                                    <th>Product</th>
                                    <th>Quantity</th>
                                    <th>Supplier/Patient</th>
                                    <th>User</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_transactions as $transaction): ?>
                                    <tr>
                                        <td><?php echo date('Y-m-d', strtotime($transaction['date'])); ?></td>
                                        <td>
                                            <span class="badge badge-<?php echo $transaction['type'] === 'receiving' ? 'success' : 'info'; ?>">
                                                <?php echo ucfirst($transaction['type']); ?>
                                            </span>
                                        </td>
                                        <td><?php echo htmlspecialchars($transaction['product_name']); ?></td>
                                        <td><?php echo $transaction['quantity']; ?></td>
                                        <td><?php echo htmlspecialchars($transaction['supplier']); ?></td>
                                        <td><?php echo htmlspecialchars($transaction['user']); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once getIncludePath('includes/footer.php'); ?> 