<?php
session_start();
require_once dirname(__DIR__, 2) . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: ' . getUrlPath('pages/login.php'));
    exit();
}

// Get database connection
$pdo = getDBConnection();

// Check if ID is provided
if (!isset($_GET['id'])) {
    $_SESSION['error_message'] = "No item ID provided.";
    header('Location: ' . getUrlPath('pages/inventory/list.php'));
    exit();
}

$id = $_GET['id'];

// Get item details
$item = getRow("SELECT * FROM inventory WHERE id = ?", [$id]);

if (!$item) {
    $_SESSION['error_message'] = "Item not found.";
    header('Location: ' . getUrlPath('pages/inventory/list.php'));
    exit();
}

// Handle deletion
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $pdo->beginTransaction();

        // Delete associated image if exists
        if ($item['product_image'] && file_exists(dirname(__DIR__, 2) . DIRECTORY_SEPARATOR . $item['product_image'])) {
            unlink(dirname(__DIR__, 2) . DIRECTORY_SEPARATOR . $item['product_image']);
        }

        // Delete the item
        if (deleteData("DELETE FROM inventory WHERE id = ?", [$id])) {
            $pdo->commit();
            $_SESSION['success_message'] = "Item deleted successfully.";
        } else {
            throw new Exception("Failed to delete item");
        }
    } catch (Exception $e) {
        $pdo->rollBack();
        $_SESSION['error_message'] = "Error deleting item: " . $e->getMessage();
    }

    header('Location: ' . getUrlPath('pages/inventory/list.php'));
    exit();
}

// Include header after all potential redirects
require_once getIncludePath('includes/header.php');
?>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title mb-0">Delete Item</h3>
                </div>
                <div class="card-body">
                    <div class="alert alert-danger">
                        <h4 class="alert-heading">Warning!</h4>
                        <p>Are you sure you want to delete this item? This action cannot be undone.</p>
                        <hr>
                        <p class="mb-0">
                            <strong>Item Details:</strong><br>
                            Product Name: <?php echo htmlspecialchars($item['product_name']); ?><br>
                            SKU: <?php echo htmlspecialchars($item['sku']); ?><br>
                            Quantity: <?php echo $item['quantity']; ?>
                        </p>
                    </div>

                    <form method="POST">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-danger">Delete Item</button>
                            <a href="<?php echo getUrlPath('pages/inventory/list.php'); ?>" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once getIncludePath('includes/footer.php'); ?> 