<?php
session_start();
require_once dirname(__DIR__, 2) . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: ' . getUrlPath('pages/login.php'));
    exit();
}

// Get database connection
$pdo = getDBConnection();

// Check if supplier ID is provided
if (!isset($_GET['id'])) {
    $_SESSION['error_message'] = "No supplier ID provided.";
    header('Location: ' . getUrlPath('pages/suppliers/list.php'));
    exit();
}

$supplier_id = $_GET['id'];

// Get supplier details
$supplier = getRow("SELECT * FROM suppliers WHERE id = ?", [$supplier_id]);

if (!$supplier) {
    $_SESSION['error_message'] = "Supplier not found.";
    header('Location: ' . getUrlPath('pages/suppliers/list.php'));
    exit();
}

// Check if supplier is being used in inventory or receiving
$inventory_count = getRow("SELECT COUNT(*) as count FROM inventory WHERE manufacturer = ?", [$supplier['name']])['count'];
$receiving_count = getRow("SELECT COUNT(*) as count FROM receiving WHERE supplier = ?", [$supplier['name']])['count'];

if ($inventory_count > 0 || $receiving_count > 0) {
    $_SESSION['error_message'] = "Cannot delete supplier. This supplier is being used in inventory or receiving records.";
    header('Location: ' . getUrlPath('pages/suppliers/list.php'));
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $pdo->beginTransaction();

        // Delete supplier
        if (deleteData("DELETE FROM suppliers WHERE id = ?", [$supplier_id])) {
            $pdo->commit();
            $_SESSION['success_message'] = "Supplier deleted successfully.";
            header('Location: ' . getUrlPath('pages/suppliers/list.php'));
            exit();
        } else {
            throw new Exception("Failed to delete supplier");
        }
    } catch (Exception $e) {
        $pdo->rollBack();
        $errors[] = "Error deleting supplier: " . $e->getMessage();
    }
}

// Include header after all potential redirects
require_once getIncludePath('includes/header.php');
?>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title mb-0">Delete Supplier</h3>
                </div>
                <div class="card-body">
                    <?php if (!empty($errors)): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php foreach ($errors as $error): ?>
                                    <li><?php echo $error; ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <div class="alert alert-warning">
                        <h4 class="alert-heading">Warning!</h4>
                        <p>Are you sure you want to delete this supplier?</p>
                        <hr>
                        <p class="mb-0">This action cannot be undone.</p>
                    </div>

                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title">Supplier Details</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Name:</strong> <?php echo htmlspecialchars($supplier['name']); ?></p>
                                    <p><strong>Contact Person:</strong> <?php echo htmlspecialchars($supplier['contact_person']); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Email:</strong> <?php echo htmlspecialchars($supplier['email']); ?></p>
                                    <p><strong>Phone:</strong> <?php echo htmlspecialchars($supplier['phone']); ?></p>
                                </div>
                            </div>
                            <p><strong>Address:</strong> <?php echo nl2br(htmlspecialchars($supplier['address'])); ?></p>
                        </div>
                    </div>

                    <form method="POST">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-danger">Delete Supplier</button>
                            <a href="<?php echo getUrlPath('pages/suppliers/list.php'); ?>" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once getIncludePath('includes/footer.php'); ?> 